/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence;

import info.msxlaunchers.openmsx.launcher.persistence.DatabaseAction;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

abstract class AbstractDatabaseOperation<E>
implements DatabaseAction<E> {
    private static final String GET_DATABASE_ID_BY_NAME_STATEMENT = "SELECT ID FROM database WHERE name=?";

    AbstractDatabaseOperation() {
    }

    @Override
    public DatabaseResponse<E> execute(String databaseFullPath) throws LauncherPersistenceException {
        DatabaseResponse<E> response = null;
        String dbURL = "jdbc:derby:" + databaseFullPath;
        try (Connection connection = DriverManager.getConnection(dbURL);){
            try {
                response = this.executeOperation(connection);
            }
            catch (LauncherPersistenceException lpe) {
                connection.rollback();
                throw lpe;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return response;
    }

    protected abstract DatabaseResponse<E> executeOperation(Connection var1) throws LauncherPersistenceException;

    protected long getDatabaseId(Connection connection, String database) {
        long id = 0L;
        try (PreparedStatement statement = connection.prepareStatement(GET_DATABASE_ID_BY_NAME_STATEMENT);){
            statement.setString(1, database);
            try (ResultSet result = statement.executeQuery();){
                result.next();
                id = result.getLong("ID");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return id;
    }

    protected void throwEncapsulatingException(Exception ex) throws LauncherPersistenceException {
        throw new LauncherPersistenceException(ex);
    }
}

